/*
 * Hack to get NIC info until gm_get_nic_info() is really implemented
 */
#include "myriInterface.h"
#include "myriProm.h"


#define GM_EEPROM(name,suffix)                                          \
struct name                                                             \
{                                                                       \
  gm_u32##suffix lanai_clockval;        /* 00-03 */                     \
  gm_u16##suffix lanai_cpu_version;     /* 04-05 */                     \
  gm_u8##suffix  lanai_board_id[6];     /* 06-0B */                     \
  gm_u32##suffix lanai_sram_size;       /* 0C-0F */                     \
  gm_u8##suffix  fpga_version[32];      /* 10-2F */                     \
  gm_u8##suffix  more_version[16];      /* 30-3F */                     \
  gm_u16##suffix delay_line_value;      /* 40-41 */                     \
  gm_u16##suffix board_type;            /* 42-43 */                     \
  gm_u16##suffix bus_type;              /* 44-45 */                     \
  gm_u16##suffix product_code;          /* 46-47 */                     \
  gm_u32##suffix serial_number;         /* 48-4B */                     \
  gm_u8##suffix  board_label[32];       /* 4C-6B */                     \
  gm_u16##suffix max_lanai_speed;       /* 6C-6D */                     \
  gm_u16##suffix future_use[7];         /* 6E-7B */                     \
  gm_u32##suffix unused_4_bytes;        /* 7C-7F */                     \
}

/* Myrinet eeprom in host order */

GM_EEPROM (gm_myrinet_eeprom, _t);
typedef struct gm_myrinet_eeprom gm_myrinet_eeprom_t;

/*
 * NIC info struct
 */
typedef struct gm_nic_info
{
  char serial_no[16];
  unsigned int product_code;
  char product_id[32];
}
gm_nic_info_t;

/*
 * More prototypes
 */
gm_status_t _gm_get_eeprom(struct gm_port *, gm_myrinet_eeprom_t *);
gm_status_t _gm_get_board_config_strings(struct gm_port *, char (*buf)[256]);

gm_status_t
gm_get_nic_info (struct gm_port *port,
		 struct gm_nic_info *nic_info)
{
  gm_myrinet_eeprom_t eeprom;
  gm_status_t status;

  /*
   * Get some things from the EEPROM:
   * - serial number
   * - product code
   * - product ID (string based on product code)
   */
  status = _gm_get_eeprom (port, &eeprom);
  if (status != GM_SUCCESS) {
    return status;
  }

  nic_info->product_code = eeprom.product_code;

  /* newer versions of Lanai have one big string with the data */
#if GM_API_VERSION >= 0x200
  if (eeprom.lanai_cpu_version >= 0xA00) {
    char board_config_strings[256];
    char *ptr;

    status = _gm_get_board_config_strings (port, &board_config_strings);
    if (status != GM_SUCCESS) {
      return status;
    }

    ptr = board_config_strings;
    while (*ptr != '\0') {
      
      if (strncmp("SN=", ptr, 3) == 0) {
	strcpy(nic_info->serial_no, ptr+3);

      } else if (strncmp("PC=", ptr, 3) == 0) {
	strcpy(nic_info->product_id, ptr+3);
      }

      /* skip to next string */
      ptr += gm_strlen (ptr) + 1;
    }


  } else
#endif
  {

    /* copy over serial number */
    sprintf(nic_info->serial_no, "%d", eeprom.serial_number);

    /* determine product ID string from EEPROM product code */
    if (PRODUCT_CODE_OK (eeprom.product_code))
      {
	char *cp;

	gm_strncpy (nic_info->product_id,
	    (char *) boards[eeprom.product_code].name,
	    sizeof(nic_info->product_id)-1);
	cp = nic_info->product_id;
	while (*cp != '\0')
	  {
	    if (*cp++ == '%')
	      {
		cp -= 2;
		*cp = '\0';
	      }
	  }
      }
    else
      {
	if (isprint (eeprom.board_label[0])
	    && isprint (eeprom.board_label[1]))
	  {
	    gm_strncpy (nic_info->product_id, (char *)eeprom.board_label,
			sizeof(nic_info->product_id)-1);
	  }
	else
	  {
	    strcpy(nic_info->product_id, "unknown");
	  }
      }
  }

  /* trim the serial number from the end, if present */
  {
    int sn_len;
    int pi_len;

    sn_len = strlen(nic_info->serial_no);
    pi_len = strlen(nic_info->product_id);
    if (pi_len > sn_len+1
	&& strcmp(nic_info->product_id + pi_len - sn_len,
                  nic_info->serial_no) == 0
	&& nic_info->product_id[pi_len - sn_len - 1] == '-') {
      nic_info->product_id[pi_len - sn_len - 1] ='\0';
    }
  }

  return GM_SUCCESS;
}
